// Exp-16 : Design Equillizer (LOW + HIGH + BANDPASS) as per the given specification 

// Version : Scilab 5.4.1
// Operating Syatem : Window-xp, Window-7

clc;
close;
clear;

function [xm1,fr1]=low(fl,fh)

delta1=0.1;
delta2=0.1;
//fl=200;
//fh=300;
fs=8000;
A=-20*log10(min(delta1:delta2));
w1=2*3.14*fl/fs;
w2=2*3.14*fh/fs;
temp=1+((A-8)/(2.285*((2*3.14*fh/fs)-(2*3.14*fl/fs))));
N=ceil((temp-1)/2);
n=-N:N;
h=(((w2+w1)/2)*(sinc(((w2+w1)/2)*n)))/(3.14);
//plot(n,h);

[xm1,fr1]=frmag(h,8000);
//figure;
//plot(fr1,xm1);

endfunction

///////////////////////////
function [xmh,frh]=highpass(fl,fh)



delta1=0.1;
delta2=0.1;
//fl=400;
//fh=500;
fs=8000;
A=-20*log10(min(delta1:delta2));
w1=2*3.14*fl/fs;
w2=2*3.14*fh/fs;
temp=1+((A-8)/(2.285*((2*3.14*fh/fs)-(2*3.14*fl/fs))));
N=ceil((temp-1)/2);
n=-N:N;
del=[zeros(1:N) 1 zeros(N+1:2*N)];
h=del-(((w2+w1)/2)*(sinc(((w2+w1)/2)*n)))/(3.14);
//h=[-h(1:30) 0 -h(32:61)];
//figure;
//plot(n,h);

[xmh,frh]=frmag(h,8000);
//figure;
//plot(frh,xmh);
endfunction


////////////////////////////////////////
function [xmb,frb]=bandpass(fl1,fh1,fl2,fh2)

delta1=0.1;
delta2=0.1;
//fl2=350;
//fh2=450;
fs=8000;
A=-20*log10(min(delta1:delta2));
w12=2*3.14*fl2/fs;
w22=2*3.14*fh2/fs;
temp2=1+((A-8)/(2.285*((2*3.14*fh2/fs)-(2*3.14*fl2/fs))));
N=ceil((temp2-1)/2);
n=-N:N;
h2=(((w22+w12)/2)*(sinc(((w22+w12)/2)*n)))/(3.14);


//[xm2,fr2]=frmag(h2,8000);

/////////////////////////////
delta1=0.1;
delta2=0.1;
//fl1=250;
//fh1=350;
fs=8000;
A=-20*log10(min(delta1:delta2));
w11=2*3.14*fl1/fs;
w21=2*3.14*fh1/fs;
temp1=1+((A-8)/(2.285*((2*3.14*fh1/fs)-(2*3.14*fl1/fs))));
N=ceil((temp1-1)/2);
n=-N:N;
h1=(((w21+w11)/2)*(sinc(((w21+w11)/2)*n)))/(3.14);

h=h2-h1;

[xmb,frb]=frmag(h,8000);


//figure;
//plot(frb,xmb);
endfunction

////////////////////Main Programm /////////////

[y,fs]=wavread('original.wav');  // User can read any .wav file

////////////    LOW PASS    ///////////////////////
fl=200;                // Lower Cut-Off Frequency
fh=300;                // Higher Cut-Off Frequency
[xm1,fr1]=low(fl,fh);  // Function for Low Pass Filter
/////////////////   HIGH PASS   //////////////////
fl=400;                // Lower Cut-Off Frequency
fh=500;                // Higher Cut-Off Frequency
[xmh,frh]=highpass(fl,fh);   // Function for high Pass Filter
//////////////////// BAND PASS    ///////////////////
fl1=250;              // Lower Cut-Off Frequency1
fh1=350;              // Higher Cut-Off Frequency1
fl2=350;              // Lower Cut-Off Frequency2
fh2=450;              // Higher Cut-Off Frequency2
[xmb,frb]=bandpass(fl1,fh1,fl2,fh2);  // Function for Band Pass Filter
///////////////////////////////////////////////////////

gain_L=2;         // Gain for Low Pass Frequency
gain_B=5;         // Gain for band Pass Frequency
gain_H=2;         // Gain for High Pass Frequency
sig_L=conv(y*gain_L,xm1);
sig_B=conv(y*gain_B,xmb);
sig_H=conv(y*gain_H,xmh);
sig_T=sig_L+sig_H+sig_B;
figure;
plot(y);
title('Original Signal (DTMF)','color','red','fontsize', 4);
xlabel("Time Index (Samples)", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

figure;
plot(sig_T);
title('Filtered Signal (DTMF)','color','red','fontsize', 4);
xlabel("Time Index (Samples)", "fontsize", 2,"color", "blue");
ylabel("Amplitude", "fontsize", 2, "color", "blue");

sound(sig_T,fs);

//sound(y,fs);
